// DirectIODlg.cpp : implementation file
//

#include "stdafx.h"
#include "DirectIO.h"
#include "DirectIODlg.h"
#include "DlgProxy.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDirectIODlg dialog

IMPLEMENT_DYNAMIC(CDirectIODlg, CDialog);

CDirectIODlg::CDirectIODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDirectIODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDirectIODlg)
	m_bit0 = FALSE;
	m_bit1 = FALSE;
	m_bit2 = FALSE;
	m_bit3 = FALSE;
	m_bit4 = FALSE;
	m_bit5 = FALSE;
	m_bit6 = FALSE;
	m_bit7 = FALSE;
	m_PC0 = FALSE;
	m_PC1 = FALSE;
	m_PC2 = FALSE;
	m_PC3 = FALSE;
	m_PC4 = FALSE;
	m_PC5 = FALSE;
	m_PC6 = FALSE;
	m_PC7 = FALSE;
	m_PA0 = FALSE;
	m_PA1 = FALSE;
	m_PA2 = FALSE;
	m_PA3 = FALSE;
	m_PA4 = FALSE;
	m_PA5 = FALSE;
	m_PA6 = FALSE;
	m_PA7 = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pAutoProxy = NULL;
}

CDirectIODlg::~CDirectIODlg()
{
	// If there is an automation proxy for this dialog, set
	//  its back pointer to this dialog to NULL, so it knows
	//  the dialog has been deleted.
	if (m_pAutoProxy != NULL)
		m_pAutoProxy->m_pDialog = NULL;
}

void CDirectIODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDirectIODlg)
	DDX_Check(pDX, IDC_CHECK1, m_bit0);
	DDX_Check(pDX, IDC_CHECK2, m_bit1);
	DDX_Check(pDX, IDC_CHECK3, m_bit2);
	DDX_Check(pDX, IDC_CHECK4, m_bit3);
	DDX_Check(pDX, IDC_CHECK5, m_bit4);
	DDX_Check(pDX, IDC_CHECK6, m_bit5);
	DDX_Check(pDX, IDC_CHECK7, m_bit6);
	DDX_Check(pDX, IDC_CHECK8, m_bit7);
	DDX_Check(pDX, IDC_CHECK17, m_PC0);
	DDX_Check(pDX, IDC_CHECK18, m_PC1);
	DDX_Check(pDX, IDC_CHECK19, m_PC2);
	DDX_Check(pDX, IDC_CHECK20, m_PC3);
	DDX_Check(pDX, IDC_CHECK21, m_PC4);
	DDX_Check(pDX, IDC_CHECK22, m_PC5);
	DDX_Check(pDX, IDC_CHECK23, m_PC6);
	DDX_Check(pDX, IDC_CHECK24, m_PC7);
	DDX_Check(pDX, IDC_CHECK9, m_PA0);
	DDX_Check(pDX, IDC_CHECK10, m_PA1);
	DDX_Check(pDX, IDC_CHECK11, m_PA2);
	DDX_Check(pDX, IDC_CHECK12, m_PA3);
	DDX_Check(pDX, IDC_CHECK13, m_PA4);
	DDX_Check(pDX, IDC_CHECK14, m_PA5);
	DDX_Check(pDX, IDC_CHECK15, m_PA6);
	DDX_Check(pDX, IDC_CHECK16, m_PA7);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDirectIODlg, CDialog)
	//{{AFX_MSG_MAP(CDirectIODlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CHECK1, OnCheck)
	ON_BN_CLICKED(IDC_CHECK9, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK17, OnPORTC)
	ON_BN_CLICKED(IDC_ALL_OFF, OnAllOff)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck)
	ON_BN_CLICKED(IDC_CHECK4, OnCheck)
	ON_BN_CLICKED(IDC_CHECK5, OnCheck)
	ON_BN_CLICKED(IDC_CHECK6, OnCheck)
	ON_BN_CLICKED(IDC_CHECK7, OnCheck)
	ON_BN_CLICKED(IDC_CHECK8, OnCheck)
	ON_BN_CLICKED(IDC_CHECK10, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK11, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK12, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK13, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK14, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK15, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK16, OnPORTA)
	ON_BN_CLICKED(IDC_CHECK18, OnPORTC)
	ON_BN_CLICKED(IDC_CHECK19, OnPORTC)
	ON_BN_CLICKED(IDC_CHECK20, OnPORTC)
	ON_BN_CLICKED(IDC_CHECK21, OnPORTC)
	ON_BN_CLICKED(IDC_CHECK22, OnPORTC)
	ON_BN_CLICKED(IDC_CHECK23, OnPORTC)
	ON_BN_CLICKED(IDC_CHECK24, OnPORTC)
	ON_BN_CLICKED(IDC_ALL_ON, OnAllOn)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDirectIODlg message handlers

BOOL CDirectIODlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	this->m_pdio->OpenDevice(0);
// write to offset of 3 the Control Register to configure
// all ports as outputs.  This is necessary for control of 
// relays on an ERB-24
	
// Control register follows logic of mode 0 of Intel 8255
// write a 0 for Output;  write a 1 for Input
// bit 0 = Port C, lower 4 bits, 1 = input, 0 =  output
// bit 1 = Port B, 1 = input, 0 = output
// bit 2 = not used, always 0
// bit 3 = Port C, upper 4 bits
// bit 4 = Port A
// bits 5,6,7 = not used, always 0

	this->m_pdio->Write(3,0x80);  // all ports outputs

	
	this->m_pdio->Write(0,0); // set all relays controlled by Port A to off
	this->m_pdio->Write(1,0); // set all relays controlled by Port B to off
	this->m_pdio->Write(2,0); // set all relays controlled by Port C to off


	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDirectIODlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDirectIODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDirectIODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// Automation servers should not exit when a user closes the UI
//  if a controller still holds on to one of its objects.  These
//  message handlers make sure that if the proxy is still in use,
//  then the UI is hidden but the dialog remains around if it
//  is dismissed.

void CDirectIODlg::OnClose() 
{
	if (CanExit())
		CDialog::OnClose();
}

void CDirectIODlg::OnOK() 
{
	if (CanExit())
		CDialog::OnOK();
}

void CDirectIODlg::OnCancel() 
{
	if (CanExit())
		CDialog::OnCancel();
}

BOOL CDirectIODlg::CanExit()
{
	// If the proxy object is still around, then the automation
	//  controller is still holding on to this application.  Leave
	//  the dialog around, but hide its UI.
	if (m_pAutoProxy != NULL)
	{
		ShowWindow(SW_HIDE);
		return FALSE;
	}

	return TRUE;
}



int CDirectIODlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here

int result;

try 
	{
		// The following smart pointer declaration will create
		// an instance of the IT2V2T object.
        KPCIDIOLib::IKPCIPIOPtr pio( __uuidof(KPCIDIOLib::KPCIPIO) );
		this->m_pdio = pio;
		result = 0;
	}
	catch (const _com_error& Err) 
	{
		TRACE( "Error in Creation of KPCIPIO object:\nError number is 0x%08X\nError message is %s\n", Err.Error( ), Err.ErrorMessage( ) );
		// Display error description if rich error info supported
		if ( Err.ErrorInfo( ) )
			TRACE( "%s\n\n", Err.Description( ) );

		result = -1;
	}
	return result;
}

void CDirectIODlg::OnDestroy() 
{
	CDialog::OnDestroy();
	// TODO: Add your message handler code here
	this->m_pdio->CloseDevice();
	
}


void CDirectIODlg::OnCheck() 
{
	// use this overloaded function to update the Relays
	// when one of the check boxes is clicked.
    int doValue;

    UpdateData(TRUE); // update from the Dialog
	doValue = 1 * m_bit0 + 2*m_bit1 + 4*m_bit2;
    doValue = doValue + 8*m_bit3 + 16*m_bit4;
	doValue = doValue+ 32*m_bit5 + 64*m_bit6 + 128*m_bit7; 

	this->m_pdio->Write(1,doValue);  // set the LSB of Port B
	// Port B controls relays 16 through 23
}

void CDirectIODlg::OnPORTA() 
{
	    int doValue;

    UpdateData(TRUE); // update from the Dialog
	doValue = 1 * m_PA0 + 2*m_PA1 + 4*m_PA2;
    doValue = doValue + 8*m_PA3 + 16*m_PA4;
	doValue = doValue+ 32*m_PA5 + 64*m_PA6 + 128*m_PA7; 

	this->m_pdio->Write(0,doValue);  // set the LSB of Port A
	// Port A controls relays 0 through 7
	
}

void CDirectIODlg::OnPORTC() 
{
	int doValue;

    UpdateData(TRUE); // update from the Dialog
	doValue = 1 * m_PC0 + 2*m_PC1 + 4*m_PC2;
    doValue = doValue + 8*m_PC3 + 16*m_PC4;
	doValue = doValue+ 32*m_PC5 + 64*m_PC6 + 128*m_PC7; 

	this->m_pdio->Write(2,doValue);  // set the LSB of Port C
	// Port C controls relays 8 through 15
	
}

void CDirectIODlg::OnAllOff() 
{
	this->m_pdio->Write(0,0); // set all relays controlled by Port A to off
	this->m_pdio->Write(1,0); // set all relays controlled by Port B to off
	this->m_pdio->Write(2,0); // set all relays controlled by Port C to off

	// need to update the check boxes with this state.....all to zero
    m_PA0 = 0;m_PA1 = 0;m_PA2 = 0;m_PA3 = 0;
	m_PA4 = 0;m_PA5 = 0;m_PA6 = 0;m_PA7 = 0;

    m_bit0 = 0;m_bit1 = 0;m_bit2 = 0;m_bit3 = 0;
	m_bit4 = 0;m_bit5 = 0;m_bit6 = 0;m_bit7 = 0;

	m_PC0 = 0;m_PC1 = 0;m_PC2 = 0;m_PC3 = 0;
	m_PC4 = 0;m_PC5 = 0;m_PC6 = 0;m_PC7 = 0;

	UpdateData(FALSE);  // update the Dialog with our all zero values
	
}

void CDirectIODlg::OnAllOn() 
{
	this->m_pdio->Write(0,0xFF); // set all relays controlled by Port A to off
	this->m_pdio->Write(1,0xFF); // set all relays controlled by Port B to off
	this->m_pdio->Write(2,0xFF); // set all relays controlled by Port C to off

	// need to update the check boxes with this state.....all to zero
    m_PA0 = 1;m_PA1 = 1;m_PA2 = 1;m_PA3 = 1;
	m_PA4 = 1;m_PA5 = 1;m_PA6 = 1;m_PA7 = 1;

    m_bit0 = 1;m_bit1 = 1;m_bit2 = 1;m_bit3 = 1;
	m_bit4 = 1;m_bit5 = 1;m_bit6 = 1;m_bit7 = 1;

	m_PC0 = 1;m_PC1 = 1;m_PC2 = 1;m_PC3 = 1;
	m_PC4 = 1;m_PC5 = 1;m_PC6 = 1;m_PC7 = 1;

	UpdateData(FALSE);  // update the Dialog with our all zero values
}
